///////////////////////////////////////////////////////////////////////////////
//
//  File:       keybd.h
//
//  Class:      KeyboardDOS - Concrete
//  
//  Hierarchy:  KeyboardDOS - Keyboard - 
//                  DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Keyboard class encapsulates keyboard access for the DOS
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _keybd_h_
#define _keybd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <dpmi.h>

//  Application Headers.
#include "keyb.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  KeyboardDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class KeyboardDOS : public Keyboard
{
    public:

        //  Build method.
        static KeyboardDOS* s_build( const KString& iName );

        //  Deletion.
        virtual ~KeyboardDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );
        
    protected:

        //  The following embedded class holds a key event.
        class KeyEvent
        {
            public:
                Byte        m_bPressed;
                KeyboardKey m_eKey;
        };

        //  Creation is protected.  Clients should use a build method.
        KeyboardDOS ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );

        //  Keyboard interrupt handler helper functions.
        void installKeyboardHandler   ( );
        void uninstallKeyboardHandler ( );

        //  Static Member Functions.
        static void s_keyboardHandler      ( );
        static void s_keyboardHandlerEnd   ( );

        //  Static Member Data.
        static Byte                sm_bKeyboardHandlerInstalled;
        static KeyEvent            sm_aKeyEventQueue[ 256 ];
        static Byte                sm_bQueueCount;
        static _go32_dpmi_seginfo  sm_oldKeyboardHandler;
        static _go32_dpmi_seginfo  sm_newKeyboardHandler;
        static const KeyboardKey   sm_aKeyCodes[ ];

    private:

};

#endif
