///////////////////////////////////////////////////////////////////////////////
//
//  File:       moused.h
//
//  Class:      MouseDOS - Concrete
//  
//  Hierarchy:  MouseDOS - Mouse - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The MouseUnixX class encapsulates mouse access for the DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _moused_h_
#define _moused_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "mouse.h"


///////////////////////////////////////////////////////////////////////////////
//  MouseDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class MouseDOS : public Mouse
{
    public:

        //  Build method.
        static MouseDOS* s_build( const KString& iName );

        //  Deletion.
        virtual ~MouseDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );

    protected:

        //  Creation is protected.  Clients should use a build method.
        MouseDOS ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );

    private:

};

#endif
