///////////////////////////////////////////////////////////////////////////////
//
//  File:       paged.h
//
//  Class:      PageDOS - Concrete
//  
//  Hierarchy:  PageDOS - Page - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window of the Replay application on
//      the DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _paged_h_
#define _paged_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "kplist.h"
#include "page.h"
#include "gmode.h"


//  Forward class declarations.
class Bitmap;


///////////////////////////////////////////////////////////////////////////////
//  PageDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class PageDOS : public Page
{
    public:

        //  Creation/Deletion.
        PageDOS ( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight,
            const Byte     bTransposed
        );
        virtual ~PageDOS ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void transpose ( );

        //  DOS specific access.
        void setGraphicsMode ( ) const;
        void draw            (
            Byte    bEasy,
            Bitmap* pBitmap, 
            int32   nX, 
            int32   nY, 
            DWord   dwWidth, 
            DWord   dwHeight 
        );

    protected:

        //  Member Functions.
        void findGraphicsMode( );

        //  Member Data.
        GraphicsMode* m_pGraphicsMode;
        Byte          m_bGoodFit;
        DWord         m_dwBorderWidth;
        DWord         m_dwBorderHeight;
        
        //  Static Member Functions.
        static void s_initializeGraphicsModes ( );

        //  Static Member Data.
        static KPtrList<GraphicsMode> sm_graphicsModeList;
        static Byte                   sm_bGraphicsModeListInitialized;
          
    private:

};

///////////////////////////////////////////////////////////////////////////////
//  PageDOS Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
PageDOS::setGraphicsMode(
) const
{
    ASSERT( m_pGraphicsMode != NULL );
    
    m_pGraphicsMode->set( );
} 


#endif
