///////////////////////////////////////////////////////////////////////////////
//
//  File:       regular.h
//
//  Class:      RegularFile - Concrete
//  
//  Hierarchy:  RegularFile - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The RegularFile class is a GameFile class that implements reading
//      of a plain old vanilla disk file.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _regular_h_
#define _regular_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdio.h>

//  Application Headers.
#include "repbase.h"
#include "kstring.h"
#include "gfile.h"


///////////////////////////////////////////////////////////////////////////////
//  RegularFile Class Definition
///////////////////////////////////////////////////////////////////////////////
class RegularFile : public GameFile
{
    public:
        
        //  Creation/Deletion.
                 RegularFile ( const KString& gameId, const KString& fileName );
        virtual ~RegularFile ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        static DWord s_fileExists(
            const KString& gameId,
            const KString& fileName,
            KString*       pFullFileName = NULL
        );

    protected:

        //  Utility.
        void open ( );

    private:

};

 
#endif
