///////////////////////////////////////////////////////////////////////////////
//
//  File:    colour.cpp
//
//  Class:   Colour
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class contains the definition of a colour.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers
#include <stdio.h>

//  Application Headers.
#include "reptypes.h"
#include "colour.h"
#include "appfile.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: Colour
//
//  Description:
//
//      This is the main constructor for a Colour object.
//
//  Parameters:
//
//      dwRed (input)
//          The red component of the colour.
//
//      dwGreen (input)
//          The green component of the colour.
//
//      dwBlue (input)
//          The blue component of the colour.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Colour::Colour(
    const DWord     dwRed   /* = 0x0000 */,
    const DWord     dwGreen /* = 0x0000 */,
    const DWord     dwBlue  /* = 0x0000 */
)
:
    RepBase    ( "aCol" ),
    m_dwRed    ( dwRed ),
    m_dwGreen  ( dwGreen ),
    m_dwBlue   ( dwBlue ),
    m_dwLocked ( 0 )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Colour
//
//  Description:
//
//      This is the destructor for a Colour object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Colour::~Colour(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Colour object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
Colour::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "Colour" );

    return( className );
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: save
//
//  Description:
//
//      This member will save the colour to a file for retrieval at a later
//      date.
//
//  Parameters:
//
//      pSaveFile
//          The file to save the colour to.
//
//  Returns:
//
//      TRUE if there were errors during the save.
//      FALSE if no errors were encountered.
//
///////////////////////////////////////////////////////////////////////////////
Byte
Colour::save(
    AppFile* pSaveFile
)
{
    ASSERT( pSaveFile != NULL );

    //  We always allow the base class to save itself first.
    RepBase::save( pSaveFile );

    //  Save the member data that keeps the state.
    pSaveFile->clearTotal( );
    pSaveFile->write( ( Byte* )&m_dwRed,    sizeof( m_dwRed ) );
    pSaveFile->write( ( Byte* )&m_dwGreen,  sizeof( m_dwGreen ) );
    pSaveFile->write( ( Byte* )&m_dwBlue,   sizeof( m_dwBlue ) );
    pSaveFile->write( ( Byte* )&m_dwLocked, sizeof( m_dwLocked ) );

    //  Was it saved successfully?
    return( pSaveFile->total( ) != ( 4 * sizeof( DWord ) ) );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: load
//
//  Description:
//
//      This member will load the colour from a file that it was previously
//      saved to.
//
//  Parameters:
//
//      pLoadFile
//          The file to load the colour from.
//
//  Returns:
//
//      TRUE if there were errors during the load.
//      FALSE if no errors were encountered.
//
///////////////////////////////////////////////////////////////////////////////
Byte
Colour::load(
    AppFile* pLoadFile
)
{
    ASSERT( pLoadFile != NULL );

    //  We always allow the base class to load itself first.
    RepBase::load( pLoadFile );

    //  Load the member data that keeps the state.
    pLoadFile->clearTotal( );
    pLoadFile->read( ( Byte* )&m_dwRed,    sizeof( m_dwRed ) );
    pLoadFile->read( ( Byte* )&m_dwGreen,  sizeof( m_dwGreen ) );
    pLoadFile->read( ( Byte* )&m_dwBlue,   sizeof( m_dwBlue ) );
    pLoadFile->read( ( Byte* )&m_dwLocked, sizeof( m_dwLocked ) );

    //  Was it loaded successfully?
    return( pLoadFile->total( ) != ( 4 * sizeof( DWord ) ) );
}
