///////////////////////////////////////////////////////////////////////////////
//
//  File:       cqueue.h
//
//  Class:      CommandQueue - Concrete
//  
//  Hierarchy:  CommandQueue - Buffer - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a queue of commands.  It is used as a buffer
//      between CPUs to allow one CPU to pass 1 byte commands to another.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cqueue_h_
#define _cqueue_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  CommandQueue Class Definition
///////////////////////////////////////////////////////////////////////////////
class CommandQueue : public Buffer
{
    public:

        //  Creation/Deletion.
        CommandQueue ( 
            const KString& iName, 
            const DWord    dwSize   = 0x01, 
            const Byte     bSustain = FALSE 
        );
        virtual ~CommandQueue ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        void addCommand ( const Byte bCommand );
        Byte getCommand ( );
        Byte pending    ( ) const;

    protected:

        //  Member data.
        Byte  m_bSustain;
        DWord m_dwIndex;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  CommandQueue Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte
CommandQueue::pending(
) const
{
    return( m_dwIndex > 0 );
}

#endif
