///////////////////////////////////////////////////////////////////////////////
//
//  File:    gamefind.cpp
//
//  Class:   GameFinder
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is used by the Game Factory to keep track of where game
//      drivers are found so that game objects can be created on request. 
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "gamefind.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameFinder
//
//  Description:
//
//      This is the main constructor for a game finder object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//      pGameInfo (input)
//          A pointer to the information object for the game.
//
//      fileName (input)
//          The name of the file that the game driver is located in.
//
//      pHandle (input)
//          An opaque handle that can be used to store any extra information
//          for locating/creating the game.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameFinder::GameFinder(
    const KString& iName, 
    GameInfo*      pGameInfo,
    const KString& fileName,
    void*          pHandle
)
:
    RepBase           ( iName ),
    m_pGameInfo       ( pGameInfo ),
    m_fileName        ( fileName ),
    m_pHandle         ( pHandle )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameFinder
//
//  Description:
//
//      This is the destructor for a game finder object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameFinder::~GameFinder(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the game finder object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameFinder::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameFinder" );

    return( className );
}
