///////////////////////////////////////////////////////////////////////////////
//
//  File:       GameInfo.h
//
//  Class:      GameInfo - Concrete
//  
//  Hierarchy:  GameInfo
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class holds information on a particular emulated game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _gameinfo_h_
#define _gameinfo_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kplist.h"

//  Forward class declarations.


///////////////////////////////////////////////////////////////////////////////
//  GameInfo Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameInfo : public RepBase
{
    public:

        //  Creation/Deletion.
                 GameInfo ( const KString& iName, const char** ppGameInfoRaw );
        virtual ~GameInfo ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        const KString& getGameId      ( ) const;
        const KString& getGameName    ( ) const;
        const KString& getVersion     ( const DWord dwIdx = 0 ) const;
        const KString& getContributor ( const DWord dwIdx = 0 ) const;
        const KString& getReqdFile    ( const DWord dwIdx = 0 ) const;

        //  Interface.
        const Byte requiredFilesAvailable ( );

    protected:

        //  Utility.
        void parseRawInfo ( const char** ppGameInfoRaw );

        //  Member Data.
        KString           m_gameId;
        KString           m_gameName;
        KPtrList<KString> m_versionList;
        KPtrList<KString> m_contributorList;
        KPtrList<KString> m_reqdFileList;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  GameInfo Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
const
KString&
GameInfo::getGameId(
) const
{
    return( m_gameId );
}

inline
const
KString&
GameInfo::getGameName(
) const
{
    return( m_gameName );
}

inline
const
KString&
GameInfo::getVersion(
    const DWord dwIdx /* = 0 */
) const
{
    return( 
        dwIdx < m_versionList.entries( ) ? 
            *( m_versionList[ dwIdx ] ) : KStringNULL 
    );
}

inline
const
KString&
GameInfo::getContributor(
    const DWord dwIdx /* = 0 */
) const
{
    return( 
        dwIdx < m_contributorList.entries( ) ? 
            *( m_contributorList[ dwIdx ] ) : KStringNULL 
    );
}

inline
const
KString&
GameInfo::getReqdFile(
    const DWord dwIdx /* = 0 */
) const
{
    return( 
        dwIdx < m_reqdFileList.entries( ) ? 
            *( m_reqdFileList[ dwIdx ] ) : KStringNULL 
    );
}


#endif
