///////////////////////////////////////////////////////////////////////////////
//
//  File:       gamfact.h
//
//  Class:      GameFactory - Concrete
//  
//  Hierarchy:  GameFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This object is a factory for creating the games that Replay knows 
//      about.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _gamfact_h_
#define _gamfact_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kpslist.h"
#include "gamefind.h"


//  Forward Declarations.
class GameInfo;
class Game;


///////////////////////////////////////////////////////////////////////////////
//  GameFactory Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameFactory : public RepBase
{
    public:

        //  Build method.
        static GameFactory* s_build( const KString& iName );

        //  Deletion.
        virtual ~GameFactory ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   
        //  Interface.
        DWord         numGames    ( ) const;
        GameInfo*     getGameInfo ( const DWord dwGameId ) const;
        virtual Game* newGame     ( const DWord dwGameId );
        virtual void  deleteGame  ( Game* pGame );


    protected:

        //  Creation is protected.  Clients should use a build method.
        GameFactory ( const KString&  iName );

        //  This function should be called from the build method.
        virtual void init ( );


        //  Member Data.
        KPtrSortList<GameFinder> m_gameFinderList;
        Game*                    m_pGame;

    private:

        //  Used to compare two games contained in a game finder on the basis 
        //  of game name.
        static int s_compareGame( const void* pGame1, const void* pGame2 );
};


///////////////////////////////////////////////////////////////////////////////
//  GameFactory Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DWord
GameFactory::numGames(
) const
{
    return( m_gameFinderList.entries( ) );
}

inline
GameInfo*
GameFactory::getGameInfo( 
    const DWord dwGameId
) const
{
    ASSERT( dwGameId < m_gameFinderList.entries( ) );
    return( m_gameFinderList[ dwGameId ]->getGameInfo( ) );
}

#endif
