///////////////////////////////////////////////////////////////////////////////
//
//  File:       input.h
//
//  Class:      Input - Concrete
//  
//  Hierarchy:  Input - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a hardware input for a game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _input_h_
#define _input_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Input Class Definition
///////////////////////////////////////////////////////////////////////////////
class Input : public RepBase
{
    public:

        //  Creation/Deletion.
                 Input ( const KString& iName, const Byte bInitial = 0x00 );
        virtual ~Input ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        Byte  getInitial  ( ) const;
        void  setInitial  ( const Byte bValue );
        Byte  getValue    ( ) const;
        void  setValue    ( const Byte bValue );
        Byte* getLocation ( );

    protected:

        //  Member data.
        Byte m_bInitial;
        Byte m_bValue;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Input Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte
Input::getInitial(
) const
{
    return( m_bInitial );
}

inline
void
Input::setInitial(
    const Byte bInitial
)
{
    m_bInitial = bInitial;
    m_bValue   = bInitial;
}

inline
Byte
Input::getValue(
) const
{
    return( m_bValue );
}

inline
void
Input::setValue(
    const Byte bValue
)
{
    m_bValue = bValue;
}

inline
Byte*
Input::getLocation(
)
{
    return( &m_bValue );
}

#endif
