///////////////////////////////////////////////////////////////////////////////
//
//  File:       sample.h
//
//  Class:      Sample - Concrete
//  
//  Hierarchy:  Sample - Buffer - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a sound sample.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sample_h_
#define _sample_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Sample Class Definition
///////////////////////////////////////////////////////////////////////////////
class Sample : public Buffer
{
    public:

        //  Creation/Deletion.
                 Sample ( const KString& iName, const DWord dwSize = 0x01 );
        virtual ~Sample ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        Byte loadSample ( const KString& gameId, const KString& sampleName );

        //  Access.
        Byte  isInitialized  ( ) const;

        void  setSize        ( const DWord dwSize );
        void  setChannel     ( const DWord dwChannel );
        void  setFrequency   ( const DWord dwFrequency );
        void  setResolution  ( const Byte  bResolution );
        void  setVolume      ( const Byte  bVolume );

        DWord getChannel     ( ) const;
        DWord getFrequency   ( ) const;
        Byte  getResolution  ( ) const;
        Byte  getVolume      ( ) const;

    protected:

        //  Member data.
        Byte  m_bInitialized;
        DWord m_dwChannel;
        DWord m_dwFrequency;
        Byte  m_bResolution;
        Byte  m_bVolume;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Sample Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte
Sample::isInitialized(
) const
{
    return( m_bInitialized );
}

inline
void
Sample::setChannel(
    const DWord dwChannel
)
{
    m_dwChannel = dwChannel;
}

inline
void
Sample::setFrequency(
    const DWord dwFrequency
)
{
    m_dwFrequency = dwFrequency;
}

inline
void
Sample::setResolution(
    const Byte bResolution
)
{
    m_bResolution = bResolution;
}

inline
void
Sample::setVolume(
    const Byte bVolume
)
{
    m_bVolume = bVolume;
}

inline
DWord
Sample::getChannel(
) const
{
    return( m_dwChannel );
}

inline
DWord
Sample::getFrequency(
) const
{
    return( m_dwFrequency );
}

inline
Byte
Sample::getResolution(
) const
{
    return( m_bResolution );
}

inline
Byte
Sample::getVolume(
) const
{
    return( m_bVolume );
}


#endif
