///////////////////////////////////////////////////////////////////////////////
//
//  File:       setting.h
//
//  Class:      Setting - Concrete
//  
//  Hierarchy:  Setting - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to keep track of a dip switch setting.  A setting
//      consists of a bit mask indicating which bits of the dip switch are
//      involved in the setting and a list of text descriptions of what
//      the various values of the mask mean in regards to the game operation.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _setting_h_
#define _setting_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "kplist.h"

//  Forward Class Declarations.
class DipSwitch;


///////////////////////////////////////////////////////////////////////////////
//  Setting Class Definition
///////////////////////////////////////////////////////////////////////////////
class Setting : public RepBase
{
    public:

        //  Creation/Deletion.
        Setting ( const KString& iName, DipSwitch* pDipSwitch, Byte bMask );
        virtual ~Setting ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        void           addDescription    ( const char* pstrDescription );
        const KString& getCurDescription ( ) const;
        void           next              ( );
        void           prev              ( );
        DipSwitch*     getDipSwitch      ( ) const;

    protected:

        //  Utility.
        Byte squashValue   ( const Byte bUnsquashed ) const;
        Byte unsquashValue ( const Byte bSquashed ) const;

        //  Member Data.
        DipSwitch*             m_pDipSwitch;
        Byte                   m_bMask;
        Byte                   m_bBitsInMask;
        KPtrList<KString>      m_descriptionList;
   
        //  Static Member Data.
        static const KString   sm_unknownDescription;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Setting Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DipSwitch*
Setting::getDipSwitch(
) const
{
    return( m_pDipSwitch );
}

#endif
