///////////////////////////////////////////////////////////////////////////////
//
//  File:       _6809pac.h
//
//  Class:      Game6809Pac - Concrete
//  
//  Hierarchy:  Game6809Pac - GameBallyMidway6809 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract base class for Pac-Man type games on Bally's
//      dual 6809 hardware.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __6809pac_h_
#define __6809pac_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_bm6809.h"



///////////////////////////////////////////////////////////////////////////////
//  Game6809Pac Class Definition
///////////////////////////////////////////////////////////////////////////////
class Game6809Pac : public GameBallyMidway6809
{
    public:

        //  Creation/Deletion.
                 Game6809Pac ( const KString& iName );
        virtual ~Game6809Pac ( );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpMemMap   ( );

        //  Non-default memory handlers.
        static DWord s_readCustom1       ( 
            DWord dwAddress, ReadHandler* pHandler 
        );
        static DWord s_readCustom2       ( 
            DWord dwAddress, ReadHandler* pHandler 
        );

        //  Member Data.
        Byte* m_pbCustom1RAM;
        Byte* m_pbCustom2RAM;
        Byte* m_pbSharedRAM;
        Byte  m_bCredits;
        Byte  m_bCoinsLeft;
        Byte  m_bCoinsRight;
        Byte  m_bCoinLeft;
        Byte  m_bCoinRight;
        Byte  m_bStart1;
        Byte  m_bStart2;

    private:

};

#endif
