///////////////////////////////////////////////////////////////////////////////
//
//  File:       de-0.h
//
//  Class:      GameDateEast0 - Concrete
//  
//  Hierarchy:  GameDataEast0 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract class that serves as a base for a series of
//      games by Data East that run on what is known as DE-0 hardware.
//      This hardware contains a 68000 for the game, a 6502 for sound,
//      a YM2203, YM3812 and an Oki M6295.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __de_0_h_
#define __de_0_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "game.h"


//  Forward class declarations.
class CommandQueue;

///////////////////////////////////////////////////////////////////////////////
//  GameDataEast0 Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameDataEast0 : public Game
{
    public:

        //  Creation/Deletion.
                 GameDataEast0 ( const KString& iName );
        virtual ~GameDataEast0 ( );

        //  Interface.
        virtual void  updateDisplay          ( 
            Bitmap* pScreen, Bitmap* pTempScreen 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpSpace    ( );
        virtual void startUpCPU      ( );
        virtual void startUpInput    ( );
        virtual void startUpGraphics ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );
        virtual void startUpMemMap   ( );

        //  Utility.
        void updateSprites ( Bitmap* pScreen );

        //  Non-default memory handlers.
        static void s_writePalette      (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeSoundCmd     (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeScreenRotate (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

        //  Member Data.
        AddrSpace*    m_pSpaceGame;
        AddrSpace*    m_pSpaceSound;
        Buffer*       m_pBufferChar;
        Buffer*       m_pBufferTile1;
        Buffer*       m_pBufferTile2;
        Buffer*       m_pBufferSprite;
        DWord*        m_pdwTileX;
        DWord*        m_pdwTileY;
        Bitmap*       m_pCharBitmap;
        Buffer*       m_pCharDirty;
        Byte*         m_pbCharScroll;
        Byte*         m_pbCharRAM;
        Bitmap*       m_pTile1Bitmap;
        Buffer*       m_pTile1Dirty;
        Byte*         m_pbTile1Scroll;
        Byte*         m_pbTile1RAM;
        Bitmap*       m_pTile2Bitmap;
        Buffer*       m_pTile2Dirty;
        Byte*         m_pbTile2Scroll;
        Byte*         m_pbTile2RAM;
        Byte*         m_pbRedRAM;
        Byte*         m_pbGreenRAM;
        Byte*         m_pbBlueRAM;
        Byte*         m_pbSpriteRAM;
        Byte*         m_pbPriorityRAM;
        CPU*          m_pCPUGame;
        CPU*          m_pCPUSound;
        GfxSet*       m_pGfxSetChar;
        GfxSet*       m_pGfxSetTile1;
        GfxSet*       m_pGfxSetTile2;
        GfxSet*       m_pGfxSetSprite;
        ColourTable*  m_pColTableChar;
        ColourTable*  m_pColTableTile1;
        ColourTable*  m_pColTableTile2;
        ColourTable*  m_pColTableSprite;
        CommandQueue* m_pSoundCommand;
        SoundDevice*  m_pYM2203;
        SoundDevice*  m_pYM3812;
        SoundDevice*  m_pOkiM6295;

    private:

};

#endif
