///////////////////////////////////////////////////////////////////////////////
//
//  File:    _robocop.cpp
//
//  Class:   GameRobocopBase
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This abstract class serves as a base for various Robocop boards.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.

//  Application Headers.
#include "_robocop.h"
#include "input.h"
#include "dip.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameRobocopBase
//
//  Description:
//
//      This is the main constructor for a Robocop game object.
//      
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameRobocopBase::GameRobocopBase(
    const KString& iName
)
:
    GameDataEast0      ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameRobocopBase
//
//  Description:
//
//      This is the destructor for a Robocop game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameRobocopBase::~GameRobocopBase(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of the Robocop hardware.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameRobocopBase::startUpInput(
)
{
    //  The base class will create the inputs and the controls.
    GameDataEast0::startUpInput( );

    //  Set up the dip switches.
    DipSwitch* pDip;
    pDip = m_dipSwitchList.add(
        new DipSwitch( "DSW0", m_inputList[ 4 ]->getLocation( ), TRUE )
    );
    pDip->addSetting(
        "Energy Meter",
        0x03,
        "Medium Energy",
        "High Energy",
        "Low Energy",
        "Very High Energy"
    );
    pDip->addSetting(
        "Game Difficulty",
        0x0c,
        "Normal Difficulty",
        "Easy Difficulty",
        "Hard Difficulty",
        "Harder Difficulty"
    );
    pDip->addSetting(
        "Continue Mode",
        0x10,
        "Continue Allowed",
        "Continue Not Allowed"
    );
    pDip->addSetting(
        "Bonus Energy",
        0x20,
        "High Bonus Energy",
        "Low Bonus Energy"
    );
    pDip->addSetting(
        "Continue Invincibility",
        0x40,
        "Cont. Invincibility Normal",
        "Cont. Invincibility Less"
    );
    pDip = m_dipSwitchList.add(
        new DipSwitch( "DSW1", m_inputList[ 5 ]->getLocation( ), TRUE )
    );
    pDip->addSetting(
        "Right Coins/Credit",
        0x03,
        "Right: 1 Coin/1 Play",
        "Right: 1 Coin/2 Plays",
        "Right: 2 Coins/1 Play",
        "Right: 3 Coins/1 Play"
    );
    pDip->addSetting(
        "Right Coins/Credit",
        0x0c,
        "Left: 1 Coin/1 Play",
        "Left: 1 Coin/2 Plays",
        "Left: 2 Coins/1 Play",
        "Left: 3 Coins/1 Play"
    );
    pDip->addSetting(
        "Attract Mode Sound",
        0x20,
        "Attract Mode Sound On",
        "Attract Mode Sound Off"
    );
    pDip->addSetting(
        "Screen Rotation",
        0x40,
        "Screen Rotation Off",
        "Screen Rotation On"
    );
    pDip->addSetting(
        "Cabinet Type",
        0x80,
        "Cocktail Cabinet",
        "Upright Cabinet"
    );
}
