///////////////////////////////////////////////////////////////////////////////
//
//  File:       _spac.h
//
//  Class:      GameSuperPacManBase - Concrete
//  
//  Hierarchy:  GameSuperPacManBase - 
//                  Game6809Pac - GameBallyMidway6809 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract base class for Super Pac-Man games.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __spac_h_
#define __spac_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_6809pac.h"



///////////////////////////////////////////////////////////////////////////////
//  GameSuperPacMan Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameSuperPacManBase : public Game6809Pac
{
    public:

        //  Creation/Deletion.
                 GameSuperPacManBase ( const KString& iName );
        virtual ~GameSuperPacManBase ( );

        //  Non-default memory handlers.
        static DWord s_readSharedRAM     ( 
            DWord dwAddress, ReadHandler* pHandler 
        );

    protected:

        //  Local Startup functions.
        virtual void startUpInput    ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );
        virtual void startUpMemMap   ( );


    private:

};

#endif
