///////////////////////////////////////////////////////////////////////////////
//
//  File:    brubber.cpp
//
//  Class:   GameBurninRubber
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Burnin' Rubber.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "brubber.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "brubber",

    ASSIGN_GAME_NAME,
        "Burnin' Rubber",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "brubber.12c",
        "brubber.12d",
        "brubber.6c",
        "brubber.4h",
        "brubber.4f",
        "brubber.4e",
        "brubber.10e",
        "brubber.10f",

FOR( brubber, GameBurninRubber )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameBurninRubber
//
//  Description:
//
//      This is the main constructor for a Burnin' Rubber object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurninRubber::GameBurninRubber(
    const KString& iName
)
:
    GameBumpNJumpBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameBurninRubber
//
//  Description:
//
//      This is the destructor for the Burnin' Rubber object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurninRubber::~GameBurninRubber(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Burnin' Rubber class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameBurninRubber::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameBurninRubber" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Burnin' Rubber.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameBurninRubber::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0c000, m_pGameInfo->getGameId( ), "brubber.12c");
    m_pSpaceGame->loadFile( 0x0e000, m_pGameInfo->getGameId( ), "brubber.12d");

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "brubber.6c" );
    
    //  Load in the foreground graphic ROMs.
    m_pBufferFG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "brubber.4e" );
    m_pBufferFG->loadFile( 0x2000, m_pGameInfo->getGameId( ), "brubber.4f" );
    m_pBufferFG->loadFile( 0x4000, m_pGameInfo->getGameId( ), "brubber.4h" );

    //  Load in the background graphic ROMs.
    m_pBufferBG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "brubber.10e" );
    m_pBufferBG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "brubber.10f" );

    //  Decrypt the game ROMs.
    decryptROMs( );
}
