///////////////////////////////////////////////////////////////////////////////
//
//  File:    btime.cpp
//
//  Class:   GameBurgerTime
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Burgertime manufactured by DECO.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "btime.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "btime",

    ASSIGN_GAME_NAME,
        "Burgertime (DECO)",

    ASSIGN_GAME_VERSION,
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "aa04.9b",
        "aa06.13b",
        "aa05.10b",
        "aa07.15b",
        "aa03.6b",
        "aa14.12h",
        "aa8.13k",
        "aa9.15k",
        "aa10.10k",
        "aa11.12k",
        "aa12.7k",
        "aa13.9k",
        "aa02.4b",
        "aa01.3b",
        "aa00.1b",

FOR( btime, GameBurgerTime )
        

//  The following array indicates which addresses contain encrypted opcodes.
static Word awEncrypted[ ] =
{
    0xc12e,0xc13c,0xc14f,0xc157,0xc15d,0xc185,0xc18d,0xc18f,0xc1ae,0xc1bd,
    0xc1c5,0xc1de,0xc1fc,0xc317,0xc31d,0xc325,0xc32c,0xc32f,0xc335,0xc33e,
    0xc347,0xc34c,0xc356,0xc366,0xc374,0xc37c,0xc387,0xc38c,0xc50c,0xc56c,
    0xc56e,0xc576,0xc57d,0xc586,0xc58c,0xc58f,0xc595,0xc597,0xc59d,0xc5a7,
    0xc5ac,0xc5b6,0xc5c4,0xc5c6,0xc5d7,0xc70d,0xc71e,0xc72d,0xc72f,0xc736,
    0xc74d,0xc74f,0xc75c,0xc764,0xc767,0xc78c,0xc795,0xc79f,0xc7c6,0xc7d7,
    0xc7dd,0xc7ec,0xc7f5,0xc91d,0xc927,0xc94e,0xc965,0xc976,0xc97f,0xc985,
    0xc98c,0xc997,0xc99e,0xc9bc,0xc9bf,0xc9cc,0xc9e5,0xcb06,0xcb0d,0xcb1e,
    0xcb34,0xcb3e,0xcb47,0xcb55,0xcb57,0xcb5d,0xcb6c,0xcb74,0xcb7d,0xcb7f,
    0xcb8d,0xcba4,0xcbb4,0xcbb6,0xcbce,0xcbee,0xcbf7,0xcbfc,0xcd36,0xcd3e,
    0xcd44,0xcd54,0xcd5d,0xcd76,0xcd87,0xcd8d,0xcd8f,0xcd95,0xcd9d,0xcda7,
    0xcdad,0xcdb6,0xcf3d,0xcf46,0xcf57,0xcf8d,0xcf9c,0xcfd7,0xcfef,0xcff7,
    0xd106,0xd11e,0xd125,0xd12c,0xd13f,0xd16e,0xd177,0xd1ad,0xd1b6,0xd1cd,
    0xd1d5,0xd1e5,0xd1e7,0xd1fe,0xd30c,0xd31f,0xd326,0xd32c,0xd32e,0xd336,
    0xd347,0xd3d5,0xd3de,0xd3e5,0xd3f4,0xd3fc,0xd51f,0xd535,0xd537,0xd53c,
    0xd53e,0xd56f,0xd584,0xd594,0xd5b7,0xd5be,0xd796,0xd7a5,0xd7be,0xd7c4,
    0xd7cf,0xd7d5,0xd7f5,0xd906,0xd917,0xd93f,0xd94e,0xd954,0xd95e,0xd97f,
    0xd987,0xd994,0xd996,0xd99e,0xd9be,0xd9e4,0xd9ed,0xd9ef,0xdb35,0xdb3f,
    0xdb5e,0xdb65,0xdb67,0xdb6c,0xdb6e,0xdb74,0xdb7d,0xdb87,0xdb95,0xdbc4,
    0xdbdf,0xdbe6,0xdbef,0xdbf4,0xdd04,0xdd14,0xdd1c,0xdd1e,0xdd65,0xdd6e,
    0xdd86,0xdd95,0xdd9d,0xddd7,0xdddd,0xddec,0xdf34,0xdf4e,0xdf54,0xdf6e,
    0xdfbc,0xdfd6,0xe107,0xe116,0xe11e,0xe12e,0xe13d,0xe15c,0xe166,0xe16d,
    0xe174,0xe196,0xe1a4,0xe1ae,0xe1c6,0xe1ee,0xe1fd,0xe1ff,0xe31f,0xe334,
    0xe357,0xe36c,0xe38f,0xe3a4,0xe3c7,0xe3dc,0xe3ff,0xe516,0xe55d,0xe56e,
    0xe57f,0xe586,0xe5b4,0xe5be,0xe5ce,0xe5d7,0xe5dc,0xe5ff,0xe717,0xe726,
    0xe737,0xe73e,0xe746,0xe76f,0xe786,0xe7be,0xe7cd,0xe93c,0xe93f,0xe94c,
    0xe965,0xe98c,0xe98f,0xe99c,0xe9af,0xe9e7,0xe9ed,0xe9f7,0xe9fe,0xeb07,
    0xeb0c,0xeb2f,0xeb34,0xeb37,0xeb3e,0xeb44,0xeb4c,0xeb77,0xeb7e,0xeb87,
    0xeb8c,0xebb5,0xebd5,0xefff,0xf107,0xf10f,0xf115,0xf117,0xf146,0xf14c,
    0xf15d,0xf164,0xf194,0xf196,0xf1ae,0xf1b6,0xf1bc,0xf1c6,0xf1d4,0xf1dc,
    0xf1ed,0xf1fd,0xf305,0xf30f,0xf317,0xf324,0xf32f,0xf35e,0xf365,0xf36d,
    0xf36f,0xf376,0xf37c,0xf38d,0xf3a5,0xf3b7,0xf3cc,0xf504,0xf515,0xf51e,
    0xf52f,0xf535,0xf53f,0xf555,0xf564,0xf577,0xf57e,0xf584,0xf586,0xf58c,
    0xf58e,0xf597,0xf59c,0xf5ad,0xf5b6,0xf5be,0xf5d7,0xf5df,0xf5ec,0xf5ee,
    0xf5f5
};




///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameBurgerTime
//
//  Description:
//
//      This is the main constructor for a DECO BurgerTime game object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurgerTime::GameBurgerTime(
    const KString& iName
)
:
    GameBurgerTimeBase ( 
        iName, 
        &( awEncrypted[ 0 ] ), 
        sizeof( awEncrypted ) / sizeof( awEncrypted[ 0 ] )
    )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameBurgerTime
//
//  Description:
//
//      This is the destructor for the DECO BurgerTime game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurgerTime::~GameBurgerTime(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Bally Burgertime game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameBurgerTime::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameBurgerTime" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Burgertime.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameBurgerTime::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0c000, m_pGameInfo->getGameId( ), "aa04.9b"    );
    m_pSpaceGame->loadFile( 0x0d000, m_pGameInfo->getGameId( ), "aa06.13b"   );
    m_pSpaceGame->loadFile( 0x0e000, m_pGameInfo->getGameId( ), "aa05.10b"   );
    m_pSpaceGame->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "aa07.15b"   );
    
    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "aa14.12h" );

    //  Load in the Map ROMs.
    m_pBufferMap->loadFile( 0x00000, m_pGameInfo->getGameId( ), "aa03.6b" );

    //  Load in the foreground graphic ROMs.
    m_pBufferFG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "aa8.13k" );
    m_pBufferFG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "aa9.15k" );
    m_pBufferFG->loadFile( 0x2000, m_pGameInfo->getGameId( ), "aa10.10k" );
    m_pBufferFG->loadFile( 0x3000, m_pGameInfo->getGameId( ), "aa11.12k" );
    m_pBufferFG->loadFile( 0x4000, m_pGameInfo->getGameId( ), "aa12.7k" );
    m_pBufferFG->loadFile( 0x5000, m_pGameInfo->getGameId( ), "aa13.9k" );

    //  Load in the background graphic ROMs.
    m_pBufferBG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "aa02.4b" );
    m_pBufferBG->loadFile( 0x0800, m_pGameInfo->getGameId( ), "aa01.3b" );
    m_pBufferBG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "aa00.1b" );

    //  Decrypt the game ROMs.
    decryptROMs( );
}
