///////////////////////////////////////////////////////////////////////////////
//
//  File:    btimeb.cpp
//
//  Class:   GameBurgerTimeBally
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Burgertime manufactured by Bally Midway.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "btimeb.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "btimeb",

    ASSIGN_GAME_NAME,
        "Burgertime (Bally)",

    ASSIGN_GAME_VERSION,
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "ab05a1.12b",
        "ab04.9b",
        "ab06.13b",
        "ab05.10b",
        "ab07.15b",
        "ab03.6b",
        "ab14.12h",
        "ab8.13k",
        "ab9.15k",
        "ab10.10k",
        "ab11.12k",
        "ab12.7k",
        "ab13.9k",
        "ab02.4b",
        "ab01.3b",
        "ab00.1b",

FOR( btimeb, GameBurgerTimeBally )
        

//  The following array indicates which addresses contain encrypted opcodes.
static Word awEncrypted[ ] = 
{
    0xb105,0xb116,0xb11e,0xb12c,0xb13d,0xb146,0xb14d,0xb154,0xb15e,0xb175,
    0xb18f,0xb195,0xb19d,0xb1a4,0xb1bd,0xb1c4,0xb1cf,0xb1d4,0xb1dd,0xb1f4,
    0xb31c,0xb326,0xb336,0xb347,0xb34f,0xb35d,0xb396,0xb39e,0xb3ad,0xb3af,
    0xb3bc,0xb3cc,0xb3dd,0xb3ed,0xb3f7,0xb507,0xb50c,0xb516,0xb525,0xb52d,
    0xb537,0xb53c,0xb544,0xb55d,0xb567,0xb56c,0xb56f,0xb575,0xb57d,0xb587,
    0xb58c,0xb594,0xb59e,0xb5ac,0xb5b6,0xb5be,0xb5d4,0xb5df,0xb5e4,0xb5e6,
    0xb5fd,0xb5ff,0xb707,0xb70d,0xb715,0xb71f,0xb73d,0xb744,0xb746,0xb74c,
    0xb755,0xb757,0xb76d,0xb786,0xb7d6,0xb7dc,0xb7fe,0xb90e,0xb916,0xb91e,
    0xb927,0xb92d,0xb92f,0xb937,0xb93f,0xb947,0xb965,0xb96f,0xb974,0xb97e,
    0xb986,0xb98c,0xb99f,0xb9a5,0xb9bc,0xb9ce,0xb9f6,0xbb0d,0xc105,0xc10e,
    0xc115,0xc15e,0xc16c,0xc17f,0xc187,0xc18d,0xc1b5,0xc1bd,0xc1bf,0xc1de,
    0xc1ed,0xc1f5,0xc347,0xc34d,0xc355,0xc35c,0xc35f,0xc365,0xc36e,0xc377,
    0xc37c,0xc386,0xc396,0xc3a4,0xc3ac,0xc3b7,0xc3bc,0xc3d6,0xc504,0xc50c,
    0xc51e,0xc525,0xc52e,0xc534,0xc537,0xc53d,0xc546,0xc54c,0xc54f,0xc557,
    0xc55e,0xc56e,0xc57d,0xc587,0xc58c,0xc594,0xc596,0xc59c,0xc5a6,0xc5bd,
    0xc7dd,0xc7ee,0xc7fd,0xc7ff,0xc906,0xc92f,0xc937,0xc93c,0xc946,0xc955,
    0xc95d,0xc966,0xc96f,0xc976,0xc97f,0xc986,0xc9b5,0xc9dd,0xcb17,0xcb1e,
    0xcb34,0xcb44,0xcb56,0xcb5e,0xcb6e,0xcb76,0xcb7e,0xcb8c,0xcb9e,0xcbad,
    0xcbb5,0xcbe4,0xcbe7,0xcd0e,0xcd14,0xcd1e,0xcd2d,0xcd3e,0xcd47,0xcd4d,
    0xcd56,0xcd6f,0xcd7c,0xcd8e,0xcda4,0xcdaf,0xcdb5,0xcdbf,0xcdc5,0xcdc7,
    0xcdce,0xcdd4,0xd105,0xd117,0xd11d,0xd124,0xd137,0xd13c,0xd15d,0xd197,
    0xd19f,0xd1a7,0xd1d6,0xd1dc,0xd1e4,0xd1ff,0xd306,0xd30d,0xd334,0xd345,
    0xd347,0xd36c,0xd394,0xd3ac,0xd3ae,0xd3b4,0xd3bf,0xd3c4,0xd3de,0xd3e6,
    0xd3ec,0xd3ee,0xd3ff,0xd50f,0xd526,0xd52c,0xd53c,0xd557,0xd55d,0xd56d,
    0xd57e,0xd58f,0xd597,0xd5a6,0xd5af,0xd5bf,0xd5ce,0xd5df,0xd5e7,0xd5f6,
    0xd72d,0xd734,0xd744,0xd757,0xd764,0xd78d,0xd90f,0xd92e,0xd937,0xd94d,
    0xd94f,0xd956,0xd95e,0xd965,0xd9b7,0xd9c5,0xd9cc,0xd9d7,0xd9f7,0xdb1d,
    0xdb45,0xdb4d,0xdb57,0xdb6d,0xdb77,0xdb8c,0xdba5,0xdbaf,0xdbb5,0xdbb7,
    0xdbbd,0xdbc5,0xdbd7,0xdbe5,0xdbed,0xdd1c,0xdd2e,0xdd47,0xdd6d,0xdd8d,
    0xdda4,0xddae,0xddb6,0xddbd,0xddd7,0xdddc,0xddde,0xddee,0xddfd,0xdf0f,
    0xdf15,0xdf1c,0xdf36,0xdf3d,0xdf67,0xdf75,0xdf87,0xdf8d,0xdf9f,0xdfa5,
    0xdfb7,0xdfbd,0xdfcf,0xdfd6,0xe10d,0xe127,0xe12e,0xe134,0xe13f,0xe157,
    0xe15c,0xe167,0xe16d,0xe17e,0xe18f,0xe1b5,0xe1be,0xe1e5,0xe1fe,0xe305,
    0xe315,0xe32d,0xe347,0xe355,0xe357,0xe35d,0xe36c,0xe376,0xe38d,0xe38f,
    0xe395,0xe3a4,0xe3ae,0xe3c5,0xe3c7,0xe3cd,0xe3dc,0xe3e6,0xe3fd,0xe3ff,
    0xe51c,0xe524,0xe53e,0xe546,0xe567,0xe56c,0xe586,0xe5ac,0xe5b5,0xe5be,
    0xe5c7,0xe5cc,0xe5ce,0xe704,0xe70f,0xe72e,0xe737,0xe746,0xe75e,0xe764,
    0xe775,0xe784,0xe794,0xe7bf,0xe7e7,0xe90f,0xe916,0xe947,0xe95e,0xe966,
    0xe96f,0xe97f,0xe986,0xe994,0xe99d,0xe9a4,0xe9ad,0xe9f5,0xeb26,0xeb35,
    0xeb75,0xeb77,0xeb7d,0xebad,0xebbd,0xebc7,0xebff,0xed2d,0xed3e,0xed56,
    0xf1af,0xf1b4,0xf1b6,0xf1bf,0xf1c5,0xf1dc,0xf1e4,0xf1ec,0xf306,0xf317,
    0xf31e,0xf34d,0xf35c,0xf36c,0xf37d,0xf387,0xf38c,0xf38e,0xf395,0xf39d,
    0xf39f,0xf3ae,0xf3b4,0xf3c6,0xf507,0xf50f,0xf51d,0xf51f,0xf524,0xf52c,
    0xf52e,0xf535,0xf537,0xf54c,0xf564,0xf576,0xf57f,0xf5c7,0xf5de,0xf5ee,
    0xf707,0xf70f,0xf714,0xf736,0xf73d,0xf73f,0xf745,0xf747,0xf74d,0xf74f,
    0xf756,0xf767,0xf76c,0xf775,0xf77d,0xf796,0xf79e,0xf7ad,0xf7b4,0xf7c7,
    0xf7dc,0xf7f7,0xf7fd,0xff1c,0xff1e,0xff3f
};




///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameBurgerTimeBally
//
//  Description:
//
//      This is the main constructor for a Bally BurgerTime game object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurgerTimeBally::GameBurgerTimeBally(
    const KString& iName
)
:
    GameBurgerTimeBase ( 
        iName, 
        &( awEncrypted[ 0 ] ), 
        sizeof( awEncrypted ) / sizeof( awEncrypted[ 0 ] )
    )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameBurgerTimeBally
//
//  Description:
//
//      This is the destructor for the Bally BurgerTime game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameBurgerTimeBally::~GameBurgerTimeBally(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Bally Burgertime game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameBurgerTimeBally::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameBurgerTimeBally" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Burgertime.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameBurgerTimeBally::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0b000, m_pGameInfo->getGameId( ), "ab05a1.12b" );
    m_pSpaceGame->loadFile( 0x0c000, m_pGameInfo->getGameId( ), "ab04.9b"    );
    m_pSpaceGame->loadFile( 0x0d000, m_pGameInfo->getGameId( ), "ab06.13b"   );
    m_pSpaceGame->loadFile( 0x0e000, m_pGameInfo->getGameId( ), "ab05.10b"   );
    m_pSpaceGame->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "ab07.15b"   );
    
    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "ab14.12h" );

    //  Load in the Map ROMs.
    m_pBufferMap->loadFile( 0x00000, m_pGameInfo->getGameId( ), "ab03.6b" );

    //  Load in the foreground graphic ROMs.
    m_pBufferFG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "ab8.13k" );
    m_pBufferFG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "ab9.15k" );
    m_pBufferFG->loadFile( 0x2000, m_pGameInfo->getGameId( ), "ab10.10k" );
    m_pBufferFG->loadFile( 0x3000, m_pGameInfo->getGameId( ), "ab11.12k" );
    m_pBufferFG->loadFile( 0x4000, m_pGameInfo->getGameId( ), "ab12.7k" );
    m_pBufferFG->loadFile( 0x5000, m_pGameInfo->getGameId( ), "ab13.9k" );

    //  Load in the background graphic ROMs.
    m_pBufferBG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "ab02.4b" );
    m_pBufferBG->loadFile( 0x0800, m_pGameInfo->getGameId( ), "ab01.3b" );
    m_pBufferBG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "ab00.1b" );

    //  Decrypt the game ROMs.
    decryptROMs( );
}
