///////////////////////////////////////////////////////////////////////////////
//
//  File:    caractn.cpp
//
//  Class:   GameCarAction
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Car Action - a bootleg Bump'n'Jump game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "caractn.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "caractn",

    ASSIGN_GAME_NAME,
        "Car Action",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",

    ASSIGN_GAME_REQD_FILES,
        "caractn.a0",
        "caractn.a1",
        "caractn.a2",
        "caractn.a3",
        "caractn.a4",
        "caractn.a5",
        "caractn.a6",
        "caractn.a7",

FOR( caractn, GameCarAction )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameCarAction
//
//  Description:
//
//      This is the main constructor for a Car Action game object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameCarAction::GameCarAction(
    const KString& iName
)
:
    GameBumpNJumpBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameCarAction
//
//  Description:
//
//      This is the destructor for the Car Action game object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameCarAction::~GameCarAction(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Car Action game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameCarAction::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameCarAction" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Car Action.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameCarAction::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0c000, m_pGameInfo->getGameId( ), "caractn.a7" );
    m_pSpaceGame->loadFile( 0x0e000, m_pGameInfo->getGameId( ), "caractn.a6" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0f000, m_pGameInfo->getGameId( ), "caractn.a5" );
    
    //  Load in the foreground graphic ROMs.
    m_pBufferFG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "caractn.a0" );
    m_pBufferFG->loadFile( 0x2000, m_pGameInfo->getGameId( ), "caractn.a1" );
    m_pBufferFG->loadFile( 0x4000, m_pGameInfo->getGameId( ), "caractn.a2" );

    //  Load in the background graphic ROMs.
    m_pBufferBG->loadFile( 0x0000, m_pGameInfo->getGameId( ), "caractn.a3" );
    m_pBufferBG->loadFile( 0x1000, m_pGameInfo->getGameId( ), "caractn.a4" );

    //  Decrypt the game ROMs.
    decryptROMs( );
}
