///////////////////////////////////////////////////////////////////////////////
//
//  File:       pacnpal.h
//
//  Class:      GamePacNPal - Concrete
//  
//  Hierarchy:  GamePacNPal - 
//                  Game6809Pac - GameBallyMidway6809 - Game - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the game object for Bally Midway's Pac'n'Pal.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _pacnpal_h_
#define _pacnpal_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "_6809pac.h"



///////////////////////////////////////////////////////////////////////////////
//  GamePacNPal Class Definition
///////////////////////////////////////////////////////////////////////////////
class GamePacNPal : public Game6809Pac
{
    public:

        //  Creation/Deletion.
                 GamePacNPal ( const KString& iName );
        virtual ~GamePacNPal ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   
        //  Non-default memory handlers.
        static DWord s_readScreenRotate (
            DWord dwAddress, ReadHandler* pHandler 
        );
        static void s_writeScreenRotate (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );
        static void s_writeSharedRAM    (
            DWord dwAddress, Byte bValue, WriteHandler* pHandler
        );

    protected:

        //  Local Startup functions.
        virtual void startUpCPU      ( );
        virtual void startUpInput    ( );
        virtual void startUpColour   ( );
        virtual void startUpSound    ( );
        virtual void startUpMemMap   ( );
        virtual void startUpROMs     ( );

    private:

};

#endif
