///////////////////////////////////////////////////////////////////////////////
//
//  File:    superpcn.cpp
//
//  Class:   GameSuperPacManNamco
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Namco's, Super Pac-Man.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "superpcn.h"
#include "gameinfo.h"
#include "space.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "superpcn",

    ASSIGN_GAME_NAME,
        "Super Pac-Man (Namco)",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Kevin Brisley",
        "Lawnmower Man (sprites)",

    ASSIGN_GAME_REQD_FILES,
        "sp1.1",
        "sp1.2",
        "sp1.4",
        "sp1.5",
        "sp1.6",

FOR( superpcn, GameSuperPacManNamco )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameSuperPacManNamco
//
//  Description:
//
//      This is the main constructor for Super Pac-Man.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameSuperPacManNamco::GameSuperPacManNamco(
    const KString& iName
)
:
    GameSuperPacManBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameSuperPacManNamco
//
//  Description:
//
//      This is the destructor for Super Pac-Man.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameSuperPacManNamco::~GameSuperPacManNamco(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Namco Super Pac-Man game class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameSuperPacManNamco::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameSuperPacManNamco" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Super Pac-Man.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameSuperPacManNamco::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0xc000, m_pGameInfo->getGameId( ), "sp1.2" );
    m_pSpaceGame->loadFile( 0xe000, m_pGameInfo->getGameId( ), "sp1.1" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0xf000, m_pGameInfo->getGameId( ), "sp1.4" );
    
    //  Load in the graphic ROMs.
    m_pBufferChar->loadFile( 0x0000, m_pGameInfo->getGameId( ), "sp1.6" );
    m_pBufferSprite->loadFile( 0x0000, m_pGameInfo->getGameId( ), "sp1.5" );
}
