///////////////////////////////////////////////////////////////////////////////
//
//  File:    turtles.cpp
//
//  Class:   GameTurpin
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for a bootleg Turtles called Turpin.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "turpin.h"
#include "gameinfo.h"
#include "space.h"
#include "dip.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "turpin",

    ASSIGN_GAME_NAME,
        "Turpin",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Robert Anschuetz  (game)",
        "Alan J. McCormick (colour)",
        "Kevin Brisley     (score)",

    ASSIGN_GAME_REQD_FILES,
        "m1",
        "m2",
        "m3",
        "m4",
        "m5",
        "c1",
        "c2",
        "d1",
        "d2",

FOR( turpin, GameTurpin )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameTurpin
//
//  Description:
//
//      This is the main constructor for Turpin.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameTurpin::GameTurpin(
    const KString& iName
)
:
    GameTurtlesBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameTurpin
//
//  Description:
//
//      This is the destructor for Turpin.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameTurpin::~GameTurpin(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Turpin class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameTurpin::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameTurpin" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Turpin.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameTurpin::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0000, m_pGameInfo->getGameId( ), "m1" );
    m_pSpaceGame->loadFile( 0x1000, m_pGameInfo->getGameId( ), "m2" );
    m_pSpaceGame->loadFile( 0x2000, m_pGameInfo->getGameId( ), "m3" );
    m_pSpaceGame->loadFile( 0x3000, m_pGameInfo->getGameId( ), "m4" );
    m_pSpaceGame->loadFile( 0x4000, m_pGameInfo->getGameId( ), "m5" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0000, m_pGameInfo->getGameId( ), "d1" );
    m_pSpaceSound->loadFile( 0x1000, m_pGameInfo->getGameId( ), "d2" );
    
    //  Load in the graphic ROMs.
    m_pBufferGfx->loadFile( 0x0000, m_pGameInfo->getGameId( ), "c1" );
    m_pBufferGfx->loadFile( 0x0800, m_pGameInfo->getGameId( ), "c2" );
}

void
GameTurpin::startUpInput(
)
{
    //  The base class will create the inputs and setup the controls.
    GameTurtlesBase::startUpInput( );

    //  The only difference between the dip switches of the various versions
    //  is the one that controls the number of lives and the one that controls
    //  the coins/credit.
    m_dipSwitchList[ 0 ]->addSetting(
        "Number of Lives",
        0x03,
        "126 Lives",
        "6 Lives",
        "4 Lives",
        "2 Lives"
    );
    m_dipSwitchList[ 1 ]->addSetting(
        "Coins/Credit",
        0x06,
        "Coins/Credits: 1/1, 1/6, 1/1",
        "Coins/Credits: 2/1, 1/3, 2/1",
        "Coins/Credits: 2/1, 2/1, 2/1",
        "Coins/Credits: 1/1, 1/1, 1/1"
    );
}
