///////////////////////////////////////////////////////////////////////////////
//
//  File:    turtles.cpp
//
//  Class:   GameTurtles
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the game object for Turtles.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "turtles.h"
#include "gameinfo.h"
#include "space.h"
#include "dip.h"
#include "buffer.h"


///////////////////////////////////////////////////////////////////////////////
//  Static declaration.
///////////////////////////////////////////////////////////////////////////////

//  Game Information.
GAME_INFO

    ASSIGN_GAME_ID,
        "turtles",

    ASSIGN_GAME_NAME,
        "Turtles",

    ASSIGN_GAME_VERSION,      
        REPLAY_MAJOR_REVISION, REPLAY_MINOR_REVISION, "1", "0",

    ASSIGN_GAME_CONTRIBUTORS,
        "Robert Anschuetz  (game)",
        "Alan J. McCormick (colour)",
        "Kevin Brisley     (score)",

    ASSIGN_GAME_REQD_FILES,
        "turt_vid.2c",
        "turt_vid.2e",
        "turt_vid.2f",
        "turt_vid.2h",
        "turt_vid.2j",
        "turt_snd.5c",
        "turt_snd.5d",
        "turt_vid.5f",
        "turt_vid.5h",

FOR( turtles, GameTurtles )



///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameTurtles
//
//  Description:
//
//      This is the main constructor for Turtles.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameTurtles::GameTurtles(
    const KString& iName
)
:
    GameTurtlesBase ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameTurtles
//
//  Description:
//
//      This is the destructor for Turtles.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameTurtles::~GameTurtles(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Turtles class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameTurtles::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameTurtles" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: startUpXXXXX
//
//  Description:
//
//      The following member functions are used to start up various aspects
//      of Turtles.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameTurtles::startUpROMs(
)
{
    //  Load in the Game ROMs.
    m_pSpaceGame->loadFile( 0x0000, m_pGameInfo->getGameId( ), "turt_vid.2c" );
    m_pSpaceGame->loadFile( 0x1000, m_pGameInfo->getGameId( ), "turt_vid.2e" );
    m_pSpaceGame->loadFile( 0x2000, m_pGameInfo->getGameId( ), "turt_vid.2f" );
    m_pSpaceGame->loadFile( 0x3000, m_pGameInfo->getGameId( ), "turt_vid.2h" );
    m_pSpaceGame->loadFile( 0x4000, m_pGameInfo->getGameId( ), "turt_vid.2j" );

    //  Load in the Sound ROMs.
    m_pSpaceSound->loadFile( 0x0000, m_pGameInfo->getGameId( ), "turt_snd.5c" );
    m_pSpaceSound->loadFile( 0x1000, m_pGameInfo->getGameId( ), "turt_snd.5d" );
    
    //  Load in the graphic ROMs.
    m_pBufferGfx->loadFile( 0x0000, m_pGameInfo->getGameId( ), "turt_vid.5h" );
    m_pBufferGfx->loadFile( 0x0800, m_pGameInfo->getGameId( ), "turt_vid.5f" );
}

void
GameTurtles::startUpInput(
)
{
    //  The base class will create the inputs and setup the controls.
    GameTurtlesBase::startUpInput( );

    //  The only difference between the dip switches of the various versions
    //  is the one that controls the number of lives and the one that controls
    //  the coins/credit.
    m_dipSwitchList[ 0 ]->addSetting(
        "Number of Lives",
        0x03,
        "126 Lives",
        "4 Lives",
        "3 Lives",
        "2 Lives"
    );
    m_dipSwitchList[ 1 ]->addSetting(
        "Coins/Credit",
        0x06,
        "Coins/Credits: 1/4, 4/1, 1/4",
        "Coins/Credits: 1/3, 3/1, 1/3",
        "Coins/Credits: 1/2, 1/1, 1/2",
        "Coins/Credits: 1/1, 2/1, 1/1"
    );
}
