///////////////////////////////////////////////////////////////////////////////
//
//  File:    canvasl.cpp
//
//  Class:   CanvasLinux
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class represents the Display of the Replay application on
//      the Linux platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "canvasl.h"
#include "bitmapl.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_build
//
//  Description:
//
//      This is a factory method to create a Linux Canvas object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      A pointer to the new object.
//
///////////////////////////////////////////////////////////////////////////////
CanvasLinux*
CanvasLinux::s_build(
    const KString& iName
)
{
    //  Create the new object.
    CanvasLinux* pThis = new CanvasLinux( iName );
 
    //  Initialize the new object.
    pThis->init( );

    //  Send back the new canvas.
    return( pThis );
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: CanvasLinux
//
//  Description:
//
//      This is the main constructor for the Linux Canvas object.  This is
//      a protected member.  Clients wishing to create a canvas object should
//      do so through the factory method.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
CanvasLinux::CanvasLinux(
    const KString& iName
)
:
    CanvasUnixX    ( iName )
{
    //  All initialization is done in init( ).
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~CanvasLinux
//
//  Description:
//
//      This is the main destructor for the Linux Canvas object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
CanvasLinux::~CanvasLinux(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the canvas object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
CanvasLinux::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "CanvasLinux" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: createBitmap
//
//  Description:
//
//      This member is used to create a blank bitmap.
//
//  Parameters:
//
//      iName (input)
//          instance name of the object.
//
//      dwWidth (input)
//          The width of the page.
//
//      dwHeight (input)
//          The height of the page.
//
//      bForScreen (input)
//          Is the bitmap a screen bitmap.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Bitmap*
CanvasLinux::createBitmap(
    const KString& iName,
    DWord          dwWidth,
    DWord          dwHeight,
    Byte           bForScreen /* = FALSE */

)
{
    //  Return a new bitmap. 
    return( 
        BitmapLinux::s_build( 
            iName, 
            dwWidth, 
            dwHeight, 
            bForScreen, 
            m_bImageScale,
            m_pDisplay, 
            m_pScreen,
            &m_visual
        ) 
    );
}
