///////////////////////////////////////////////////////////////////////////////
//
//  File:       configl.h
//
//  Class:      ConfigurationLinux - Concrete
//  
//  Hierarchy:  ConfigurationLinux - 
//                  ConfigurationUnixX - Configuration - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a Linux Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _configl_h_
#define _configl_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configx.h"


///////////////////////////////////////////////////////////////////////////////
//  ConfigurationLinux Class Definition
///////////////////////////////////////////////////////////////////////////////
class ConfigurationLinux : public ConfigurationUnixX
{
    public:

        //  Deletion.
        virtual ~ConfigurationLinux ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation/Deletion.
        ConfigurationLinux ( const KString& iName );

    private:

        //  Static Member Data.
        static ConfigurationLinux sm_configurationLinux;
};


#endif
