///////////////////////////////////////////////////////////////////////////////
//
//  File:       client.h
//
//  Class:      NetGameClientMeddler - Concrete
//  
//  Hierarchy:  NetGameClientMeddler - NetGameMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to handle the duties of a client during a net
//      game.  The client informs the server of its state and processes
//      coordination messages from the server.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _client_h_
#define _client_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "netgame.h"
#include "kstring.h"


//  Forward Class Declarations.
class Game;


///////////////////////////////////////////////////////////////////////////////
//  NetGameClientMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class NetGameClientMeddler : public NetGameMeddler
{
    public:

        //  Build method.
        static NetGameClientMeddler* s_build( 
            const KString& iName, Game* pGame 
        );

        //  Deletion.
        virtual ~NetGameClientMeddler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface. 
        virtual void  update                 ( );

    protected:

        //  Creation/Initialization.
        NetGameClientMeddler   ( const KString& iName, Game* pGame );
        virtual void init      ( );

        //  Member Data.

    private:

};


#endif
