///////////////////////////////////////////////////////////////////////////////
//
//  File:       meddler.h
//
//  Class:      Meddler - Abstract
//  
//  Hierarchy:  Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents an object that is used to modify the state
//      of a game in Replay.  It is used when the game needs to be controlled
//      by in external source other than, or in addition to, the user.
//
//      This class is an abstract object representing the interface for
//      all Meddler objects.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _meddler_h_
#define _meddler_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"


//  Forward Class Declarations.
class Game;


///////////////////////////////////////////////////////////////////////////////
//  Meddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class Meddler : public RepBase
{
    public:

        //  Deletion.
        virtual ~Meddler ( );

        //  Interface.
        virtual void           update        ( ) = 0;
        virtual void           activate      ( );
        virtual void           deactivate    ( );
        virtual void           terminate     ( );
        Byte                   complete      ( ) const;
        virtual const KString& getDecoration ( ) const;

    protected:

        //  Creation/Initialization.
                     Meddler ( const KString& iName, Game* pGame );
        virtual void init    ( );

        //  Member data.
        Game* m_pGame;
        Byte  m_bComplete;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Meddler Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte
Meddler::complete(
) const
{
    return( m_bComplete );
}

#endif
