///////////////////////////////////////////////////////////////////////////////
//
//  File:       play.h
//
//  Class:      MoviePlayMeddler - Concrete
//  
//  Hierarchy:  MoviePlayMeddler - MovieMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to play a movie of the current game being 
//      emulated.  Movies to be played must have previously been recorded
//      using the MovieRecordMeddler class.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _play_h_
#define _play_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "movie.h"
#include "kstring.h"


//  Forward Class Declarations.
class Game;


///////////////////////////////////////////////////////////////////////////////
//  MoviePlayMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class MoviePlayMeddler : public MovieMeddler
{
    public:

        //  Build method.
        static MoviePlayMeddler* s_build( const KString& iName, Game* pGame );

        //  Deletion.
        virtual ~MoviePlayMeddler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface. 
        virtual void  update                 ( );
        virtual void  activate               ( );
        virtual void  deactivate             ( );
        virtual const KString& getDecoration ( ) const;

    protected:

        //  Creation/Initialization.
        MoviePlayMeddler   ( const KString& iName, Game* pGame );
        virtual void init  ( );

        //  Utility.
        void enableHardware ( Byte bEnable ) const;

        //  Member Data.
        DWord m_dwFrame;
        DWord m_dwEndTime;

    private:

};


#endif
