///////////////////////////////////////////////////////////////////////////////
//
//  File:       server.h
//
//  Class:      NetGameServerMeddler - Concrete
//  
//  Hierarchy:  NetGameServerMeddler - NetGameMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to handle the duties of a server during a net
//      game.  The server coordinates the execution of the game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _server_h_
#define _server_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "netgame.h"
#include "kstring.h"


//  Forward Class Declarations.
class Game;


///////////////////////////////////////////////////////////////////////////////
//  NetGameServerMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class NetGameServerMeddler : public NetGameMeddler
{
    public:

        //  Build method.
        static NetGameServerMeddler* s_build( 
            const KString& iName, Game* pGame 
        );

        //  Deletion.
        virtual ~NetGameServerMeddler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface. 
        virtual void  update                 ( );

    protected:

        //  Creation/Initialization.
        NetGameServerMeddler   ( const KString& iName, Game* pGame );
        virtual void init      ( );

        //  Utility.
        void assignPlayerNumbers ( );

        //  Member Data.

    private:

};


#endif
