///////////////////////////////////////////////////////////////////////////////
//
//  File:       disk.h
//
//  Class:      Disk - Abstract
//  
//  Hierarchy:  Disk - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Disk class is an abstract base class encapsulating disk
//      access.  A derived class for each platform should be created
//      from this base.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _disk_h_
#define _disk_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"
#include "kplist.h"

//  Forward class declarations.
class GameFile;

///////////////////////////////////////////////////////////////////////////////
//  Disk Class Definition
///////////////////////////////////////////////////////////////////////////////
class Disk : public RepBase
{
    public:

        //  The following are the various game file locations supported.
        typedef enum
        {
            LOC_NOTFOUND,

            LOC_REGULAR,
            LOC_ZIP,
            LOC_ROMLIB
        }
        GameFileLocation;

        //  Creation/Deletion.
                 Disk ( const KString& iName );
        virtual ~Disk ( );

        //  File Access.
        const Byte gameFileExists        ( 
            const KString& gameId, const KString& fileName 
        ) const;
        GameFile*  gameFileOpen          ( 
            const KString& gameId, const KString& fileName 
        ) const;
        void       gameFileClose         ( GameFile* pGameFile ) const;
        const Byte gameFileLoad          ( 
            const KString&     gameId, 
            const KString&     fileName, 
            Byte*              pbDest, 
            const DWord        dwMaxLength, 
            const DWord        dwOffset = 0x0000,
            const Byte         bSkip    = FALSE
        );
        virtual const DWord checkForFile ( 
            KString& path, const KString& fileName 
        );

        //  Directory Access.
        const DWord            getNumPaths             ( ) const;
        const KString&         getPath                 ( 
            DWord dwIdx = 0 
        ) const;
        virtual void           makeDirectoryComponents ( 
            const KString& fileName 
        );
        virtual const KString& getDirectorySeparator   ( ) const;

    protected:

        //  Utility.
        virtual GameFileLocation gameFileLocation ( 
            const KString& gameId, const KString& fileName 
        ) const;
        virtual void             setWorkingDirectory ( );
        void                     getPaths ( );


        //  Member Data.
        KPtrList<KString> m_pathList;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Disk Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
const
DWord
Disk::getNumPaths(
) const
{
    return( m_pathList.entries( ) );
}

inline
const
KString&
Disk::getPath(
    DWord dwIdx /* = 0 */
) const
{
    ASSERT( dwIdx < m_pathList.entries( ) );
    return( *( m_pathList[ dwIdx ] ) );
}


#endif
