///////////////////////////////////////////////////////////////////////////////
//
//  File:       param.h
//
//  Class:      Parameter - Concrete
//  
//  Hierarchy:  Parameter - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Parameter class is an class encapsulating a command line
//      parameter.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _param_h_
#define _param_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Parameter Class Definition
///////////////////////////////////////////////////////////////////////////////
class Parameter : public RepBase
{
    public:

        //  Deletion.
        Parameter ( 
            const KString& parameter,
            const KString& argumentDesc,
            const KString& parameterDesc
        );
        virtual ~Parameter ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        void found ( const KString& argument = KStringNULL );

        //  Access.
        const Byte     isFound          ( ) const;
        const KString& getParameter     ( ) const;
        const KString& getParameterDesc ( ) const;
        const KString& getArgument      ( ) const;
        const KString& getArgumentDesc  ( ) const;

    protected:

        //  Member Data.
        Byte    m_bFound;
        KString m_parameter;
        KString m_parameterDesc;
        KString m_argument;
        KString m_argumentDesc;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Parameter Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
Parameter::found(
    const KString& argument /* = KStringNULL */
)
{
    m_bFound = TRUE;
    if( argument != KStringNULL );
    {
        m_argument = argument;
    }
}

inline
const
Byte
Parameter::isFound(
) const
{
    return( m_bFound );
}

inline
const
KString&
Parameter::getParameter(
) const
{
    return( m_parameter );
}

inline
const
KString&
Parameter::getParameterDesc(
) const
{
    return( m_parameterDesc );
}

inline
const
KString&
Parameter::getArgument(
) const
{
    return( m_argument );
}

inline
const
KString&
Parameter::getArgumentDesc(
) const
{
    return( m_argumentDesc );
}

#endif
