///////////////////////////////////////////////////////////////////////////////
//
//  File:       registry.h
//
//  Class:      Registry - Concrete
//  
//  Hierarchy:  Registry - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for keeping a "registry"
//      of values based on group/name pairs.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _registry_h_
#define _registry_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "kpslist.h"
#include "reptypes.h"
#include "repbase.h"

//  Forward Class Declarations.
class AppFile;

///////////////////////////////////////////////////////////////////////////////
//  Registry Class Definition
///////////////////////////////////////////////////////////////////////////////
class Registry : public RepBase
{
    public:

        //  The types of registries allowed.
        typedef enum
        {
            CONFIG,
            SCORES
        }
        Contents;

        //  Creation/Deletion.
                 Registry ( const KString& iName, const Contents eContents );
        virtual ~Registry ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        void        deleteValue  ( const KString& group, const KString& name );
        const DWord getValueSize ( const KString& group, const KString& name );
        const DWord getValue     ( 
            const KString& group, 
            const KString& name, 
            Byte*          pbResult, 
            DWord          dwMaxLength
        );
        void setValue            (
            const KString& group, 
            const KString& name, 
            Byte*          pbValue,
            DWord          dwLength
        );

    protected:

        //  The following structure is used as an entry into the registry.
        struct RegistryEntry
        {
            char*          pstrGroup;
            char*          pstrName;
            DWord          dwOffset;
            DWord          dwSize;
            RegistryEntry* pNext;
        };
        
        //  Initialization.
        void initialize  ( );
        void loadEntries ( );
        void createEmpty ( );

        //  List manipulation.
        void           newEntry    ( RegistryEntry* pEntry );
        void           deleteEntry ( RegistryEntry* pEntry );
        void           addEntry    ( RegistryEntry* pEntry );
        void           removeEntry ( RegistryEntry* pEntry );
        RegistryEntry* findEntry   ( 
            const KString& group, const KString& name 
        ) const;

        //  Member Data.
        Contents              m_eContents;
        KString               m_fileName;
        AppFile*              m_pAppFile;
        DWord                 m_dwNumEntries;
        RegistryEntry*        m_pEntryHead;
        RegistryEntry*        m_pEntryTail;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Registry Inline Functions.
///////////////////////////////////////////////////////////////////////////////


#endif
