///////////////////////////////////////////////////////////////////////////////
//
//  File:    repfact.cpp
//
//  Class:   ReplayFactory
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is a singleton abstract factory providing clients with
//      a common interface for creating objects that have dependencies on
//      the current platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdio.h>

//  Application Headers.
#include "repfact.h"


///////////////////////////////////////////////////////////////////////////////
//  Static Member Initialization.
///////////////////////////////////////////////////////////////////////////////

//  A pointer to the singleton instance.  This will get set in the 
//  constructor when the one and only derived concrete class is instantiated.
ReplayFactory* ReplayFactory::sm_pInstance = NULL;


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ReplayFactory
//
//  Description:
//
//      This is the main constructor for a replay factory object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ReplayFactory::ReplayFactory(
    const KString& iName
)
:
    RepBase        ( iName )
{
    //  Assign the instance pointer.
    ASSERT( sm_pInstance == NULL );
    sm_pInstance = this;
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ReplayFactory
//
//  Description:
//
//      This is the destructor for a Replay Factory object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ReplayFactory::~ReplayFactory(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_instance
//
//  Description:
//
//      This member returns the singleton Replay Factory.  It will actually
//      return a concrete factory based on the platform.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      A reference to the singleton factory.
//
///////////////////////////////////////////////////////////////////////////////
ReplayFactory&
ReplayFactory::s_instance(
)
{
    //  Return the instance.
    ASSERT( sm_pInstance != NULL );
    return( *sm_pInstance );
}
