///////////////////////////////////////////////////////////////////////////////
//
//  File:       reptypes.h
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This defines some basic types, macros, etc. used in Replay.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _reptypes_h_
#define _reptypes_h_

//  System Headers.
#include <assert.h>


//  Forward class declarations.
class CPU;


///////////////////////////////////////////////////////////////////////////////
//  Macros.
///////////////////////////////////////////////////////////////////////////////
//  Standard boolean if they don't exist.
#if !defined(TRUE)
#define TRUE 1
#endif
#if !defined(FALSE)
#define FALSE 0
#endif

//  We have a macro for assert in case we ever want to change it in the future.
#define ASSERT(COND) assert(COND)

//  Use this macro to compare floats without round-off error.
#define CLOSE_ENOUGH(A,B) \
    ((A==B)||((A<B)&&((B-A)<.001))||((A>B)&&((A-B)<.001)))

///////////////////////////////////////////////////////////////////////////////
//  Types.
///////////////////////////////////////////////////////////////////////////////

//  Various integer types.
typedef signed char        int8;
typedef signed short       int16;
typedef signed long        int32;
typedef unsigned char      uint8;
typedef unsigned short     uint16;
typedef unsigned long      uint32;

//  Integer types in the context of a CPU emulation.
typedef int8               Offset;
typedef uint8              Byte;
typedef uint16             Word;
typedef uint32             DWord;

//  The form of a CPU interrupt function.
typedef int32 ( *CPUIntFunc )( CPU* );
    

///////////////////////////////////////////////////////////////////////////////
//  Constants.
///////////////////////////////////////////////////////////////////////////////
const int8  GAME_NAME_LENGTH    = 32;


#endif
