///////////////////////////////////////////////////////////////////////////////
//
//  File:       sound.h
//
//  Class:      Sound - Abstract
//  
//  Hierarchy:  Sound - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Sound class is an abstract base class encapsulating sound
//      control.  A derived class for each platform should be created
//      from this base.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sound_h_
#define _sound_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


//  Forward Class Declarations.
class Sample;

///////////////////////////////////////////////////////////////////////////////
//  Sound Class Definition
///////////////////////////////////////////////////////////////////////////////
class Sound : public RepBase
{
    public:

        //  Creation/Deletion.
                 Sound ( const KString& iName );
        virtual ~Sound ( );

        //  Access.
        DWord getSampleRate ( ) const;
        DWord getSampleBits ( ) const;
        DWord getChannel    ( );
        void  resetChannels ( );
        Byte  useOPL        ( ) const;
        Byte  isEnabled     ( ) const;

        //  General Interface.
        virtual Byte update       ( ) = 0;
        virtual void play         ( Sample* pSample, const Byte bLoop ) = 0;
        virtual void playStreamed ( Sample* pSample ) = 0;
        virtual void stop         ( const DWord dwChannel ) = 0;
        virtual void stopAll      ( );

    protected:

        //  Utility.
        virtual DWord getNumChannels ( ) const = 0;

        //  Member Data.
        Byte  m_bEnabled;
        Byte  m_bAllowsOPL;
        Byte  m_bSupportsOPL;
        DWord m_dwSampleRate;
        DWord m_dwSampleBits;
        DWord m_dwNextAvailableChannel;

    private:

        //  Static Member Data.
        static const DWord sm_dwSampleRateMin;
        static const DWord sm_dwSampleRateMax;
        static const DWord sm_dwSampleRateDef;
        static const DWord sm_dwSampleBitsDef;
};


///////////////////////////////////////////////////////////////////////////////
//  Sound Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DWord
Sound::getSampleRate(
) const
{
    return( m_dwSampleRate );
}

inline
DWord
Sound::getSampleBits(
) const
{
    return( m_dwSampleBits );
}

inline
Byte
Sound::isEnabled(
) const
{
    return( m_bEnabled );
}

inline
Byte
Sound::useOPL(
) const
{
    return( m_bAllowsOPL && m_bSupportsOPL );
}

#endif
