///////////////////////////////////////////////////////////////////////////////
//
//  File:       ssscli.h
//
//  Class:      SSStateClient - Concrete
//  
//  Hierarchy:  SSStateClient - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for synchronizing
//      with a server when Replay is acting as a client.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ssscli_h_
#define _ssscli_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"
#include "network.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateClient Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateClient : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateClient ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateClient ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual Action  execute   ( ColourTable* pColourTable );
        virtual void    fillHelp  ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );
        virtual void    setState  ( );

    protected:

        //  The synchronization messages.
        typedef enum
        {
            SYNCHRO_NONE,

            SYNCHRO_SEND_START,
            SYNCHRO_RECV_GAME,
            SYNCHRO_RECV_DIPS,
            SYNCHRO_SEND_READY,
            SYNCHRO_RECV_GO
        }
        Synchro;

        //  Utility.
        void continueSynchro  ( );
        void synchroSendStart ( );
        void synchroRecvGame  ( );
        void synchroRecvDips  ( );
        void synchroSendReady ( );
        void synchroRecvGo    ( );

        //  Member Data.
        Network*      m_pNetwork;
        Synchro       m_eSynchro;
        Byte          m_bAbort;
        Network::Msg* m_pMsg;
        char          m_strLine[ 64 ];

    private:

};

#endif
