///////////////////////////////////////////////////////////////////////////////
//
//  File:       ssskeyc.h
//
//  Class:      SSStateKeyConfig - Concrete
//  
//  Hierarchy:  SSStateKeyConfig - SSStateControlConfig - 
//                  SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for allowing the
//      user to configure the keyboard controls.  It allows for setting
//      both the global Replay game controls and for setting the current
//      game's controls.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ssskeyc_h_
#define _ssskeyc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssscfg.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class CtrlMap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateKeyConfig Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateKeyConfig : public SSStateControlConfig
{
    public:

        //  Creation/Deletion.
        SSStateKeyConfig ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateKeyConfig ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

    private:

};

#endif
