///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssmiss.h
//
//  Class:      SSStateMissingFiles - Concrete
//  
//  Hierarchy:  SSStateMissingFiles - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for displaying
//      the required files for the current game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssmiss_h_
#define _sssmiss_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateMissingFiles Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateMissingFiles : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateMissingFiles ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateMissingFiles ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void    setGameInfo ( GameInfo* pGameInfo );
        virtual Action  execute     ( ColourTable* pColourTable );
        virtual void    fillHelp    ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  Member Data.

    private:

};

#endif
