///////////////////////////////////////////////////////////////////////////////
//
//  File:       ssspause.h
//
//  Class:      SSStatePause - Concrete
//  
//  Hierarchy:  SSStatePause - SSStatePause - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for showing a
//      paused display of the current game while allowing options to be set.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ssspause_h_
#define _ssspause_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "sssbase.h"
#include "clip.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Clock;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStatePause Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStatePause : public SSStateBase
{
    public:

        //  Creation/Deletion.
        SSStatePause ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStatePause ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual Action  execute   ( ColourTable* pColourTable );
        virtual void    fillHelp  ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );
        virtual Bitmap* getScreen ( );

    protected:

        //  Member Data.
        Clock*   m_pClock;
        Clipping m_clipping;

    private:

};

#endif
