///////////////////////////////////////////////////////////////////////////////
//
//  File:    configs.cpp
//
//  Class:   ConfigurationSolaris
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a Solaris Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configs.h"


///////////////////////////////////////////////////////////////////////////////
//  File Static Variables.
///////////////////////////////////////////////////////////////////////////////

//  The singleton instance.
ConfigurationSolaris 
    ConfigurationSolaris::sm_configurationSolaris( "Configuration" );


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ConfigurationSolaris
//
//  Description:
//
//      This is the main constructor for the Solaris Unix/X configuration 
//      object.  It is protected because it is a singleton and therefore 
//      cannot be instantiated by anyone but itself or a derived class.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationSolaris::ConfigurationSolaris(
    const KString& iName
)
:
    ConfigurationUnixX ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ConfigurationSolaris
//
//  Description:
//
//      This is the destructor for the Solaris Unix/X configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationSolaris::~ConfigurationSolaris(
)
{
    //  Nothing to do.
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
ConfigurationSolaris::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "ConfigurationSolaris" );

    return( className );
}
