///////////////////////////////////////////////////////////////////////////////
//
//  File:       configl.h
//
//  Class:      ConfigurationSolaris - Concrete
//  
//  Hierarchy:  ConfigurationSolaris - 
//                  ConfigurationUnixX - Configuration - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a Solaris Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _configs_h_
#define _configs_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configx.h"


///////////////////////////////////////////////////////////////////////////////
//  ConfigurationSolaris Class Definition
///////////////////////////////////////////////////////////////////////////////
class ConfigurationSolaris : public ConfigurationUnixX
{
    public:

        //  Deletion.
        virtual ~ConfigurationSolaris ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation/Deletion.
        ConfigurationSolaris ( const KString& iName );

    private:

        //  Static Member Data.
        static ConfigurationSolaris sm_configurationSolaris;
};


#endif
