///////////////////////////////////////////////////////////////////////////////
//
//  File:    sdev.cpp
//
//  Class:   SoundDevice
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The SoundDevice class serves a base class for a group of classes that
//      are responsible for emulating various sound devices that appeared
//      in classic arcade games (i.e. PSGs, DACs, etc.).
//
//      SoundDevice provides an abstract interface for the game drivers
//      to communicate with these devices.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "sdev.h"
#include "replay.h"
#include "sound.h"




///////////////////////////////////////////////////////////////////////////////
//
//  Function: SoundDevice
//
//  Description:
//
//      This is the main constructor for a sound device object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SoundDevice::SoundDevice(
    const KString& iName
)
:
    RepBase           ( iName ),
    m_pSound          ( Replay::s_instance( ).getSound( ) )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~SoundDevice
//
//  Description:
//
//      This is the destructor for a sound device object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SoundDevice::~SoundDevice(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: update
//
//  Description:
//
//      This member is called to allow the sound device to update itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
SoundDevice::update(
)
{
    //  No default behaviour.
}
