///////////////////////////////////////////////////////////////////////////////
//
//  File:       ym3812.h
//
//  Class:      YM3812 - Concrete
//  
//  Hierarchy:  YM3812 - SoundDevice - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is responsible for emulating the Yamaha YM3812 sound chip.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ym3812_h_
#define _ym3812_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "sdev.h"



///////////////////////////////////////////////////////////////////////////////
//  WaveForm Class Definition
///////////////////////////////////////////////////////////////////////////////
class YM3812 : public SoundDevice
{
    public:
        
        //  Creation/Deletion.
                 YM3812 ( const KString& iName );
        virtual ~YM3812 ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Chip Manipulation.
        void       setRegister         ( const Byte bRegister );
        void       writeRegister       ( const Byte bValue );
        const Byte readRegister        ( );
        const Byte getStatus           ( );

    protected:

        //  Member Data.
        Byte m_bUseOPL;

    private:

};



#endif
