///////////////////////////////////////////////////////////////////////////////
//
//  File:       bytemod.h
//
//  Class:      ByteModifier - Concrete
//  
//  Hierarchy:  ByteModifier
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The ByteModifier class is a simple, lightweight class 
//      which is used for modifying a memory byte.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _bytemode_h_
#define _bytemode_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdlib.h>

//  Application Headers.
#include "reptypes.h"


///////////////////////////////////////////////////////////////////////////////
//  ByteModifier Class Definition
///////////////////////////////////////////////////////////////////////////////
class ByteModifier
{
    public:

        //  Creation/Deletion.
        ByteModifier  ( Byte* bLocation, Byte bMask );
        ~ByteModifier ( );

        //  Access.
        void modify   ( Byte bSet );

    protected:

        //  Member Data.
        Byte* m_pbLocation;
        Byte  m_bMask;
        Byte  m_bNotMask;
        Byte  m_bReverse;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  ByteModifier Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
ByteModifier::modify(
    Byte bSet
)
{
    ASSERT( m_pbLocation != NULL );

    //  Modify the masked bits in the byte.
    if( ( !m_bReverse && bSet ) || ( m_bReverse && !bSet ) )
    {
        *m_pbLocation |= m_bMask;
    }
    else
    {
        *m_pbLocation &= m_bNotMask;
    }
}


#endif
