///////////////////////////////////////////////////////////////////////////////
//
//  File:    kpslist.cpp
//
//  Class:   KPtrSortList
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is a lightweight templated pointer list that is sorted.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdlib.h>

//  Application Headers.
#include "kpslist.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: KPtrSortList
//
//  Description:
//
//      This constructor creates an empty KPtrSortList.
//
//  Parameters:
//
//      nIncrement (input)
//          The number of elements to grow the list by when more space is
//          needed.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
template <class TC>  
KPtrSortList<TC>::KPtrSortList(
    int ( *pfCompare ) ( const void *, const void * ),
    int nIncrement /*=20*/
)
:
    KPtrList<TC>  ( nIncrement ),
    m_pfCompare   ( pfCompare )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~KPtrSortList
//
//  Description:
//
//      This is the destructor for the KPtrSortList object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
template <class TC> 
KPtrSortList<TC>::~KPtrSortList(
)
{
    //  Taken care of by the base class.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: add
//
//  Description:
//
//      This function adds an item to the list.
//
//  Parameters:
//
//      pItem (input)
//          The item to add to the list.
//
//  Returns:
//      A pointer to the item added.
//
///////////////////////////////////////////////////////////////////////////////
template <class TC>
TC*
KPtrSortList<TC>::add(
    TC* pItem
)
{
    //  Add the list as per the base class.
    KPtrList<TC>::add( pItem );

    //  Now sort the pointers.
    qsort( ( void* )m_ppList, m_nNumItems, sizeof( pItem ), m_pfCompare );

    //  Return the item just added.
    return( pItem );
}

//////////////////////
//  Templated classes.
//////////////////////
class GameFinder;
template class KPtrSortList<GameFinder>;
class Slice;
template class KPtrSortList<Slice>;
