///////////////////////////////////////////////////////////////////////////////
//
//  File:       matrix.h
//
//  Class:      Matrix - Concrete
//  
//  Hierarchy:  Matrix
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Matrix class is a simple, lightweight class 
//      which is used for manipulating an mxn matrix represented 
//      by a one dimensional array in row form.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _matrix_h_
#define _matrix_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////
//  Matrix Class Definition
///////////////////////////////////////////////////////////////////////////////
template <class TC> class Matrix
{
    public:

        //  Creation/Deletion.
        Matrix  (
            TC*       pBuffer = NULL, 
            const int nWidth  = 0, 
            const int nHeight = 0
        );
        ~Matrix ( );

        //  Manipulation.
        void setup      ( TC* pBuffer, const int nWidth, const int nHeight );
        void transpose  ( );
        void flip       ( unsigned char bFlipX, unsigned char bFlipY );

    protected:

        //  Member Data.
        TC* m_pBuffer;
        int m_nWidth;
        int m_nHeight;
        int m_nSize;

    private:

};



#endif
