///////////////////////////////////////////////////////////////////////////////
//
//  File:       bitmapx.h
//
//  Class:      BitmapUnixX - Concrete
//  
//  Hierarchy:  BitmapUniX - Bitmap - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a bitmap that can be displayed on the screen
//      for the Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _bitmapx_h_
#define _bitmapx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.

//  X Headers.
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef XSHM
#include <X11/extensions/XShm.h>
#endif

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "bitmap.h"

//  Forward class declarations.


///////////////////////////////////////////////////////////////////////////////
//  BitmapUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class BitmapUnixX : public Bitmap
{
    public:

        //  Build Method.
        static BitmapUnixX* s_build( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight, 
            const Byte     bScreen  = FALSE,
            const Byte     bScale   = 0,
            Display*       pDisplay = NULL,
            Screen*        pScreen  = NULL,
            XVisualInfo*   pVisual  = NULL
        );

        //  Deletion.
        virtual ~BitmapUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        XImage* getImage  ( ) const;

        //  Utility.
        void transferBuffer ( const DWord* pdwPixelList );

    protected:

        //  Creation is protected since a build method should be used.
        BitmapUnixX ( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight, 
            const Byte     bScreen  = FALSE,
            const Byte     bScale   = 0,
            Display*       pDisplay = NULL,
            Screen*        pScreen  = NULL,
            XVisualInfo*   pVisual  = NULL
        );

        //  Initialization.
        virtual void init ( );

        //  Utility.
        virtual void swapXY ( );

        //  Member data.
        XImage*          m_pImage;
        Display*         m_pDisplay;
        Screen*          m_pScreen;
        XVisualInfo*     m_pVisual;
#ifdef XSHM
        XShmSegmentInfo  m_shmInfo;
#endif
        Byte             m_bScale;
        Byte*            m_pbImageBuffer;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  BitmapUnixX Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
XImage*
BitmapUnixX::getImage(
) const
{
    return( m_pImage );
}

#endif
