///////////////////////////////////////////////////////////////////////////////
//
//  File:    configx.cpp
//
//  Class:   ConfigurationUnixX
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configx.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ConfigurationUnixX
//
//  Description:
//
//      This is the main constructor for the Unix/X configuration object.  It
//      is protected because it is a singleton and therefore cannot be 
//      instantiated by anyone but itself or a derived class.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationUnixX::ConfigurationUnixX(
    const KString& iName
)
:
    Configuration       ( iName )
{
    //  Add the parameters that are common for all Unix/X versions.
    addParam( "-host", "<hostname>", "The host the server is running on." );
    addParam( "-port", "<portnum>",  "The port the server is listening to." );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ConfigurationUnixX
//
//  Description:
//
//      This is the destructor for the Unix/X configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationUnixX::~ConfigurationUnixX(
)
{
    //  Nothing to do.
}
