///////////////////////////////////////////////////////////////////////////////
//
//  File:       gamfactx.h
//
//  Class:      GameFactoryUnixX - Concrete
//  
//  Hierarchy:  GameFactoryUnixX - GameFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This object is a factory for creating the games that Replay knows 
//      about.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _gamfactx_h_
#define _gamfactx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "gamfact.h"


//  Forward Declarations.
class GameFinder;
class GameInfo;
class Game;


///////////////////////////////////////////////////////////////////////////////
//  GameFactoryUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class GameFactoryUnixX : public GameFactory
{
    public:

        //  Build method.
        static GameFactoryUnixX* s_build( const KString& iName );

        //  Deletion.
        virtual ~GameFactoryUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
   
        //  Interface.
        virtual Game* newGame     ( const DWord dwGameId );
        virtual void  deleteGame  ( Game* pGame );


    protected:

        //  Creation is protected.  Clients should use a build method.
        GameFactoryUnixX ( const KString&  iName );

        //  This function should be called from the build method.
        virtual void init ( );

        //  Utility.
        void  addGames     ( const KString& libDir );

        //  Member Data.
        GameFinder* m_pGameFinder;
        void*       m_pLibrary;
        
    private:

};


#endif
